<?php

namespace App\Http\Controllers;

use App\Models\GroupLoan;
use App\Models\GroupLoanRepayment;
use Illuminate\Http\Request;

class GroupLoanRepaymentController extends Controller
{
    public function store(Request $request, $loanId)
{
    $data = $request->validate([
        'member_id'     => 'required|exists:users,id',
        'amount'        => 'required|numeric|min:100',
        'payment_date'  => 'required|date',
        'notes'         => 'nullable|string'
    ]);

    $loan = GroupLoan::findOrFail($loanId);

    // Create repayment entry
    $repayment = GroupLoanRepayment::create([
        'group_loan_id' => $loan->id,
        'member_id'     => $data['member_id'],
        'amount'        => $data['amount'],
        'payment_date'  => $data['payment_date'],
        'notes'         => $data['notes'] ?? null,
    ]);

    // Reduce balance
    $loan->balance -= $data['amount'];

    if ($loan->balance <= 0) {
        $loan->balance = 0;
        $loan->status = 'completed';
    }

    $loan->save();

    return back()->with('success', 'Repayment recorded successfully.');
}

}
