<?php

namespace App\Http\Controllers;

use App\Models\GroupLoan;
use App\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GroupLoanController extends Controller
{
    // Show create form
    public function create($groupId)
    {
        $group = Group::with('members')->findOrFail($groupId);

        return view('admin.group_loans.create', compact('group'));
    }

    public function index()
{
    $loans = GroupLoan::with('group')
        ->orderBy('created_at', 'desc')
        ->get();

    return view('admin.group_loans.index', compact('loans'));
}

    // Save new group loan
    public function store(Request $request, $groupId)
    {
        $data = $request->validate([
            'principal' => 'required|numeric|min:1',
            'interest_rate' => 'required|numeric|min:0',
            'loan_period_months' => 'required|integer|min:1',
        ]);

        $group = Group::findOrFail($groupId);

        $loan = GroupLoan::create([
            'group_id' => $group->id,
            'principal' => $data['principal'],
            'interest_rate' => $data['interest_rate'],
            'loan_period_months' => $data['loan_period_months'],
            'balance' => $data['principal'],
            'status' => 'pending',
        ]);

        return redirect()
            ->route('admin.loans.show', $loan->id)
            ->with('success', 'Group loan created successfully.');
    }

    // Approve loan
    public function approve($id)
    {
        $loan = GroupLoan::findOrFail($id);
        $loan->status = 'approved';
        $loan->save();

        return back()->with('success', 'Loan approved.');
    }

    // Disburse loan
    public function disburse($id)
    {
        $loan = GroupLoan::findOrFail($id);

        DB::transaction(function () use ($loan) {
            $loan->status = 'active';
            $loan->disbursed_at = now();
            $loan->save();
        });

        return back()->with('success', 'Loan disbursed.');
    }

    // Show the loan (admin view)
  public function show($id)
{
    $loan = GroupLoan::with(['group.users', 'repayments.member'])->findOrFail($id);
    return view('admin.group_loans.show', compact('loan'));
}


    // Member dashboard
    public function indexForMember($memberId)
    {
        $memberGroups = DB::table('group_members')
            ->where('member_id', $memberId)
            ->pluck('group_id');

        $loans = GroupLoan::whereIn('group_id', $memberGroups)
            ->with('group')
            ->get();

        return view('members.group_loans', compact('loans'));
    }
}
