<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\ShareTransaction;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminShareController extends Controller
{
    public function index()
    {
        $shares = ShareTransaction::with('member')->latest()->paginate(20);
        return view('admin.shares.index', compact('shares'));
    }

    public function create(User $user)
    {
        return view('admin.shares.create', compact('user'));
    }

    public function store(Request $request, User $user)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1',
            'price_per_share' => 'required|numeric|min:1',
            'notes' => 'nullable|string',
        ]);

        $shares = floor($request->amount / $request->price_per_share);

        ShareTransaction::create([
            'user_id' => $user->id,
            'admin_id' => Auth::id(),
            'amount' => $request->amount,
            'price_per_share' => $request->price_per_share,
            'shares' => $shares,
            'reference' => $request->reference ?? null,
            'notes' => $request->notes,
        ]);

        return redirect()->route('admin.shares.index')
            ->with('success', 'Share purchase recorded successfully.');
    }
}
