<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Account;
use App\Models\Transaction;
use App\Models\Loan;

class AdminController extends Controller
{
    public function index()
    {

    $totalLoans        = Loan::count();
    $pendingLoans      = Loan::where('status', 'pending')->count();
    $approvedLoans     = Loan::where('status', 'approved')->count();
    $disbursedLoans    = Loan::where('status', 'disbursed')->count();
    $rejectedLoans     = Loan::where('status', 'rejected')->count();
    $closedLoans       = Loan::where('status', 'closed')->count();

    $totalLoanAmountRequested = Loan::sum('principal');
    $totalLoanAmountApproved  = Loan::whereNotNull('approved_at')->sum('principal');
    $totalLoanAmountDisbursed = Loan::where('status', 'disbursed')->sum('principal');

        // Basic Stats
        $userCount       = User::count();
        $memberCount     = User::where('role', 'member')->count();
        $adminCount      = User::where('role', 'admin')->count();
        $accountCount    = Account::count();
        $transactionCount = Transaction::count();

        // Financial Stats
        $totalDeposits = Transaction::where('type', 'deposit')->sum('amount');
        $totalWithdrawals = Transaction::where('type', 'withdrawal')->sum('amount');
        $netBalance = $totalDeposits - $totalWithdrawals;

        // Recent Items
        $recentUsers = User::latest()->take(5)->get();
        $recentAccounts = Account::latest()->take(5)->get();
        $recentTransactions = Transaction::with('account.user')
                                ->latest()
                                ->take(5)
                                ->get();

                                // =============================
// 12-Month Deposits & Withdrawals Graph Data
// =============================
$months = collect(range(0, 11))->map(function ($i) {
    return now()->subMonths($i)->format('Y-m');
})->reverse()->values();

$chartLabels = [];
$chartDeposits = [];
$chartWithdrawals = [];

foreach ($months as $month) {
    $chartLabels[] = \Carbon\Carbon::parse($month . '-01')->format('M Y');

    $chartDeposits[] = Transaction::where('type', 'deposit')
        ->whereYear('created_at', substr($month, 0, 4))
        ->whereMonth('created_at', substr($month, 5, 2))
        ->sum('amount');

    $chartWithdrawals[] = Transaction::where('type', 'withdrawal')
        ->whereYear('created_at', substr($month, 0, 4))
        ->whereMonth('created_at', substr($month, 5, 2))
        ->sum('amount');
}



       return view('admin.dashboard', compact(
    'userCount',
    'memberCount',
    'adminCount',
    'accountCount',
    'transactionCount',
    'totalDeposits',
    'totalWithdrawals',
    'netBalance',
    'recentUsers',
    'recentAccounts',
    'recentTransactions',
    'chartLabels',
    'chartDeposits',
    'chartWithdrawals',

    // new loan stats:
        'totalLoans', 'pendingLoans', 'approvedLoans', 'disbursedLoans',
        'rejectedLoans', 'closedLoans',
        'totalLoanAmountRequested', 'totalLoanAmountApproved', 'totalLoanAmountDisbursed',

        'chartLabels', 'chartDeposits', 'chartWithdrawals'
));

    }
}
